<?php
class Infortis_Ultimo_Model_Observer
{
    public function beforeBlockToHtml(Varien_Event_Observer $observer)
    {
        
        
        
        $grid = $observer->getBlock();

        /**
         * Mage_Adminhtml_Block_Customer_Grid
         */
        if ($grid instanceof Mage_Adminhtml_Block_Customer_Grid) {
            $grid->addColumnAfter(
                'customercode',
                array(
                    'header' => Mage::helper('adminhtml')->__('Customer code'),
                    'index'  => 'customercode',
                    'width'=>'50px',
                ),
                'email'
            );
            $grid->addColumnAfter(
                'company',
                array(
                    'header' => Mage::helper('adminhtml')->__('Company'),
                    'index'  => 'company',
                    'width'=>'50px',
                ),
                'customercode'
            );
        }
    }

    public function beforeCollectionLoad(Varien_Event_Observer $observer)
    {
        $collection = $observer->getCollection();
        if (!isset($collection)) {
            return;
        }

        /**
         * Mage_Customer_Model_Resource_Customer_Collection
         */
        if ($collection instanceof Mage_Customer_Model_Resource_Customer_Collection) {
            /* @var $collection Mage_Customer_Model_Resource_Customer_Collection */
            $collection->addAttributeToSelect('customercode');
            $collection->addAttributeToSelect('company');
        }
    }
}
