<?php
class Exceed_ImportExport_Model_Import_Entity_Product extends Mage_ImportExport_Model_Import_Entity_Product
{

    /**
     * Save product categories.
     *
     * @param array $categoriesData
     * @return Mage_ImportExport_Model_Import_Entity_Product
     */
    protected function _saveProductCategories(array $categoriesData)
    {
        static $tableName = null;

        if (!$tableName) {
            $tableName = Mage::getModel('importexport/import_proxy_product_resource')->getProductCategoryTable();
        }
        if ($categoriesData) {
            $categoriesIn = array();
            $delProductId = array();

            foreach ($categoriesData as $delSku => $categories) {
                $productId      = $this->_newSku[$delSku]['entity_id'];
                $delProductId[] = $productId;

                foreach (array_keys($categories) as $categoryId) {
                    
                    //Get position
                    $select = $this->_connection->select()
                            ->from($tableName, array('position'))
                            ->where('category_id =?', (int)$categoryId)
                            ->where('product_id =?', (int)$productId);
                    
                    $position = $this->_connection->fetchOne($select);
                    
                    Mage::log(sprintf("P:%s, C:%s, POS:%s",$productId, $categoryId, $position), null, '2.lo');
                    
                    $categoriesIn[] = array('product_id' => $productId, 'category_id' => $categoryId, 'position' => ($position) ? $position : 1);
                }
            }
            if (Mage_ImportExport_Model_Import::BEHAVIOR_APPEND != $this->getBehavior()) {
                $this->_connection->delete(
                    $tableName,
                    $this->_connection->quoteInto('product_id IN (?)', $delProductId)
                );
            }
            if ($categoriesIn) {
                $this->_connection->insertOnDuplicate($tableName, $categoriesIn, array('position'));
            }
        }
        return $this;
    }

}
