<?php 
/**
 * Customziation the GST and Shipping fee display order in Onepage Checkout page
 * 
 * @author Leo
 * @date 05/02/2014
 * @mail leo@exceedonline.co.nz
 *
 */
class Exceed_Customization_Block_Cart_Totals extends Mage_Checkout_Block_Cart_Totals {
	
	/**
     * Customization - Render totals html for specific totals area (footer, body)
     *
     * @param   null|string $area
     * @param   int $colspan
     * @return  string
     */
    public function customRenderTotals($area = null, $colspan = 1)
    {
       $html = '';
       $totals = array();
       foreach($this->getTotals() as $total) {
        	if ($total->getArea() != $area && $area != -1) {
                continue;
            }
            $totals[] = $this->renderTotal($total, $area, $colspan);
           
        }
        $html = $totals[0] . $totals[2] . $totals[1];
        if ($num >= 3) $html .= $totals[3] . $totals[4];
        
        return $html;
    }
}