<?php

class Magebin_Productimport_Model_Orderexport {
	
	public $connector;

	public function init(){
		if(!Mage::getStoreConfig('advanced/orderexport/orderexport_active')) return;
		$this->connector = Mage::getStoreConfig('advanced/orderexport/orderexport_connect');
		$this->connector = Mage::getModel('productimport/adapter_'.$this->connector);
		$this->connector->initLog(Mage::getModel('productimport/log'));
		$this->connector->login(Mage::getStoreConfig('advanced/orderexport/orderexport_remote'),Mage::getStoreConfig('advanced/orderexport/orderexport_port'),Mage::getStoreConfig('advanced/orderexport/orderexport_username'),Mage::getStoreConfig('advanced/orderexport/orderexport_password'));
		$this->connector->cd(Mage::getStoreConfig('advanced/orderexport/orderexport_folder'));
	}
	
	
	public function getOrders(){
		$collection = Mage::getModel('sales/order')->getCollection()->addFieldtoFilter('exported',array('neq'=>'1'));
		return $collection;
	
	}
	
	
	/*public function csvcontent($orders){
			$tmpfile = tmpfile();
			foreach($orders as $order){
				$data = array();
				for($i=0; $i<11; $i++){
					$column = Mage::getStoreConfig('advanced/orderexport/orderexport_column'.$i);
					$column = trim($column);
					if(!empty($column)){
						$data[] = $order->getData($column);
					}
				}
				fputcsv($tmpfile, $data);
			}
			return file_get_contents($tmpfile);
	}*/
	
	
	public function csvcontent($orders){
			$tmpfile = tmpfile();
			foreach($orders as $order){
				$items = $order->getAllItems();
				$j = 0;
				foreach($items as $item){
					$j+=1;
					$data = array();
					$customer = Mage::getModel('customer/customer')->load($order->getCustomerId());
					
					$data[] = $order->getIncrementId();
					$data[] = $customer->getCode();
					$data[] = $customer->getPO();
					$data[] = $customer->getPO();
					
					
					
					$data[] = $customer->getCode();
					$data[] = $customer->getPO();
					$data[] = $order->getId();
					$data[] = $j;
					$data[] = Mage::app()->getLocale()->date(strtotime($order->getCreatedAtStoreDate()), null, null, false)->toString('YmdHis');
					$deliverytime = "";
					foreach($order->getShipmentsCollection() as $shipment){
						$deliverytime = $shipment->getCreatedAt();
					}
					if(!empty($deliverytime)){
						$data[] = Mage::app()->getLocale()->date(strtotime($deliverytime), null, null, false)->toString('YmdHis');
					}
					$data[] = $order->getTotalPaid();
					$data[] = 1;
					$data[] = 'COUR';
					$data[] = $item->getSku();
					$data[] = $item->getQty();
					$data[] = $item->getPrice();
					
				}
				
				
				fputcsv($tmpfile, $data);
			}
			

			$contents = '';
			fseek($tmpfile, 0);
			while (!feof($tmpfile)) {
			  $contents .= fread($tmpfile,1024);
			}
			
			return $contents;
			
		}
	
	
	
	
	public function cron(){

		if(!Mage::getStoreConfig('advanced/orderexport/orderexport_active')) return;
		$orders = $this->getOrders();
		if($orders->getSize()==0) return false;
		$this->init();
		//Costumers_20130819_2345.xls
		$filename = "orders_".  date("Ymd") . "_" .date("Hi") . ".csv";
		try{
			$content = $this->csvcontent($orders);
			$this->connector->write($filename,$content);
		}catch(Exception $e){
			$error = 'can export orders of file '.$filename.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		
		foreach($orders as $order){
			$order->setExported(true);
			$order->setExportedTime(time());
			$order->save();
		}
				
		return true;

	}
	
	
	
	
	
	
	
	
	
	
	
}

