<?php

class Magebin_Productimport_Model_Orderexport {
	
	public $connector;

	public function init(){
		if(!Mage::getStoreConfig('advanced/orderexport/orderexport_active')) return;
		$this->connector = Mage::getStoreConfig('advanced/orderexport/orderexport_connect');
		$this->connector = Mage::getModel('productimport/adapter_'.$this->connector);
		$this->connector->initLog(Mage::getModel('productimport/log'));
		$this->connector->login(Mage::getStoreConfig('advanced/orderexport/orderexport_remote'),Mage::getStoreConfig('advanced/orderexport/orderexport_port'),Mage::getStoreConfig('advanced/orderexport/orderexport_username'),Mage::getStoreConfig('advanced/orderexport/orderexport_password'));
		$this->connector->cd(Mage::getStoreConfig('advanced/orderexport/orderexport_folder'));
	}
	
	
	public function getOrders(){
		$collection = Mage::getModel('sales/order')->getCollection()->addFieldtoFilter('exported',array('neq'=>'1'));
		return $collection;
	
	}
	
	
	/*public function csvcontent($orders){
			$tmpfile = tmpfile();
			foreach($orders as $order){
				$data = array();
				for($i=0; $i<11; $i++){
					$column = Mage::getStoreConfig('advanced/orderexport/orderexport_column'.$i);
					$column = trim($column);
					if(!empty($column)){
						$data[] = $order->getData($column);
					}
				}
				fputcsv($tmpfile, $data);
			}
			return file_get_contents($tmpfile);
	}*/
	
	
	public function csvcontent($orders){
			$tmpfile = tmpfile();
			foreach($orders as $order){
				
				
				$customer = Mage::getModel('customer/customer')->load($order->getCustomerId());
				
				$ordered_items = $order->getAllItems(); 
				foreach($ordered_items as $item){
					$line_content = '';
					/*echo $item->getItemId();
					echo $item->getSku();
					echo $item->getQtyOrdered();
					echo $item->getName();*/
			
					//add order number
					//
					$line_content .= str_pad('', 10);
					//add order customer code
					$line_content .= str_pad($customer->getCustomercode(), 10);
					//add customer PO
					$line_content .= str_pad($customer->getPO(), 10);
					//add stock code
					$line_content .= str_pad($item->getSku(), 35);
					//add description
					$line_content .= str_pad($item->getDescription(), 25);
					//add price
					$price = number_format($item->getPrice(),2);
					$line_content .= str_pad($price, 20);
					//add qty ordered
					$qty = $item->getQtyOrdered();
					$qty = round($qty, 2);
					$line_content .= str_pad($qty, 12);
					//add order date
					$order_date = $order->getCreatedAtStoreDate();
					$order_date = strtotime($order_date);
					$order_date = date("mdY", $order_date);
					$line_content .= str_pad($order_date, 8);
					//add order delivery date
					$delivery_date = '';
					$shipments = $order->getShipmentsCollection();
					foreach($shipments as $shipment){
						$delivery_date = $shipment->getCreatedAt();
						$delivery_date = strtotime($delivery_date);
						$delivery_date = date("mdY", $delivery_date);			
						$delivery_date = $delivery_date;
					}
					$line_content .= str_pad($delivery_date, 8);
					//add order type
					$line_content .= str_pad('1', 1);
					//add payment term
					$line_content .= str_pad('02', 2);
					//add delivery term
					$line_content .= str_pad('04', 2);
					//add order status
					$line_content .= str_pad('3', 1);
					//add remark line
					$increment_id = $order->getIncrementId();					
					$line_content .= str_pad($increment_id, 35);
					$line_content .= str_pad($order->getShippingAmount(), 3);
					
					//148+32 = 3
					
					fwrite($tmpfile, $line_content."\r\n" );
					//fwrite($tmpfile, "\n");
				
				}

				

			}
			$contents = '';
			fseek($tmpfile, 0);
			while (!feof($tmpfile)) {
			  $contents .= fread($tmpfile,1024);
			}
			
			$contents =  iconv("UTF-8", "Windows-1252", $contents);
			return $contents;
			
		}
	
	
	
	
	public function cron(){

		if(!Mage::getStoreConfig('advanced/orderexport/orderexport_active')) return;
		Mage::log('export orders started', null, 'multichem-integration.log');
		$orders = $this->getOrders();
		if($orders->getSize()==0) return false;
		$this->init();
		//Costumers_20130819_2345.xls
		$filename = "orders_".  date("Ymd") . "_" .date("Hi") . ".prn";
		try{
			$content = $this->csvcontent($orders);
			$this->connector->write($filename,$content);
		}catch(Exception $e){
			$error = 'can export orders of file '.$filename.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		
		foreach($orders as $order){
            
            Mage::log('hourly orders run', null, 'multichem-integration.log');
            
			$order->setExported(true);
			$order->setExportedTime(time());
			$order->save();
		}
		Mage::log('export orders ended', null, 'multichem-integration.log');
				
		return true;

	}
    
    public function cronHourly(){
		if(Mage::getStoreConfig('advanced/customerimport/orderexport_hourly') == 1)
            
            Mage::log('hourly orders started', null, 'multichem-integration.log');
            
            $this->cron();
	}
	
	
	
	
	
	
	
	
	
	
	
}

