<?php

class Magebin_Productimport_Model_Importprice {
	
	public $connector;

	public function init(){
		if(!Mage::getStoreConfig('advanced/priceimport/priceimport_active')) return;
		$this->connector = Mage::getStoreConfig('advanced/priceimport/priceimport_connect');
		$this->connector = Mage::getModel('productimport/adapter_'.$this->connector);
		$this->connector->initLog(Mage::getModel('productimport/log'));
		$this->connector->login(Mage::getStoreConfig('advanced/priceimport/priceimport_remote'),Mage::getStoreConfig('advanced/priceimport/priceimport_port'),Mage::getStoreConfig('advanced/priceimport/priceimport_username'),Mage::getStoreConfig('advanced/priceimport/priceimport_password'));
		$this->connector->cd(Mage::getStoreConfig('advanced/priceimport/priceimport_folder'));
	}
	
	
	public function filterFiles($files){
		$result = array();
		// filter .csv files
		foreach($files as $f){
			$extension = end(explode('.', $f));
			if(strtolower($extension)=='csv'){
				$result[] = $f;
			}
			if(strtolower($extension)=='xls'){
				$result[] = $f;
			}
		}
		return $result;
	}
		
	
	public function importFiles($files){
		foreach($files as $file){
			$this->importFile($file);
		}
	}
	
	public function importFile($file){
		$csv_data = $this->connector->read($file);
		$tmpfile = Mage::getBaseDir('var')."/".$file;
		file_put_contents($tmpfile, $csv_data);
		
		require_once(Mage::getBaseDir()."/PHPExcel.php");
		$products = array();
		
		try{ 
			$sheet_name = 'Price_data';
			$objReader = PHPExcel_IOFactory::createReaderForFile($tmpfile);
			$objReader->setLoadSheetsOnly(array($sheet_name));
			$objReader->setReadDataOnly(true);

			$objPHPExcel = $objReader->load($tmpfile);
			$highestColumm = $objPHPExcel->setActiveSheetIndex(0)->getHighestColumn();
			$highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();
			
			$m = 0;
	
			foreach ($objPHPExcel->setActiveSheetIndex(0)->getRowIterator() as $row) {
				$m=$m+1;
				if($m<3) continue;
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false);
				$productData = array();$j=0;
				
				foreach ($cellIterator as $cell) {
					$j=$j+1;
					if (!is_null($cell) ) {
						$value = $cell->getCalculatedValue();
						$value = trim($value);
						if( !empty($value) ){
							$key = Mage::getStoreConfig('advanced/priceimport/priceimport_column'.$j);
							$key = trim($key);
							if(!empty($key)){
								$productData[$key] = $value;
							}
						}
					}
				}
			
				$products[] = $productData;
			}
		}catch(Exception $e){
			$this->connector->log('system','import file error ' . $e->getMessage(),$file);
			$this->connector->move($file,'issues/'.$file);
			return false;
		}
		
		/*$lines = explode("\n", $csv_data);
		$head = str_getcsv(array_shift($lines));
		$data = array();
		foreach ($lines as $line) {
			$data[] = array_combine($head, str_getcsv($line));
		}*/
		
		unlink($tmpfile);
		
		try{
			$this->importToMagento($products);
		}catch(Exception $e){
			$this->connector->move($file,'issues/'.$file);
			$this->connector->log('system','import file error ' . $e->getMessage(),$file);
			return false;
		}
		
		
		$this->connector->move($file,'archive/'.$file);
		return true;
	}
	
	
	public function importToMagento($data){

		foreach($data as $productData){
			$product = null;
			if(!empty($productData['sku'])){
				$product_id = Mage::getModel('catalog/product')->getIdBySku($productData['sku'] );
				if(isset($product_id)){
					$product = Mage::getModel('catalog/product')->load($product_id);
				}
			}
			if(!$product){
				$product = Mage::getModel('catalog/product');
				$product->setSku(time()); 
				$product->setAttributeSetId('4');
				$product->setTypeId('simple'); 
				$product->setName('iscala product'); 
				$product->setCategoryIds(array(0)); # some cat id's, 
				$product->setWebsiteIDs(array(1)); # Website id, 1 is default 
				$product->setDescription('description'); 
				$product->setPrice(0);
				$product->setWeight(0); 
				$product->setVisibility(Mage_Catalog_Model_Product_Visibility::VISIBILITY_NOT_VISIBLE); 
				$product->setStatus(0); 
				$product->setTaxClassId(0); 	
			}
			foreach($productData as $key=>$value){
				if(strrpos($key,'tock.')){
					$newkey = explode('.',$key);
					$product->setStockData(array( 
						$newkey[1] => $value 
					)); 
				}else{
					$product->setData($key,$value);
				}
			}
			$product->save();
		}
	}
	
	
	public function cron(){
		if(!Mage::getStoreConfig('advanced/priceimport/priceimport_active')) return;
		Mage::log('import price started', null, 'multichem-integration.log');
		$this->init();
		$contents = $this->connector->ls("");
		$files = $this->filterFiles($contents['file']);
		$this->importFiles($files);
		Mage::log('import price ended', null, 'multichem-integration.log');
	}
	
	
	
}

