<?php

class Magebin_Productimport_Model_Importcustomer
{

    public $connector;

    public function init()
    {
        if (!Mage::getStoreConfig('advanced/customerimport/customerimport_active')) return;
        $this->connector = Mage::getStoreConfig('advanced/customerimport/customerimport_connect');
        $this->connector = Mage::getModel('productimport/adapter_' . $this->connector);
        $this->connector->initLog(Mage::getModel('productimport/log'));
        $this->connector->login(Mage::getStoreConfig('advanced/customerimport/customerimport_remote'), Mage::getStoreConfig('advanced/customerimport/customerimport_port'), Mage::getStoreConfig('advanced/customerimport/customerimport_username'), Mage::getStoreConfig('advanced/customerimport/customerimport_password'));
        $this->connector->cd(Mage::getStoreConfig('advanced/customerimport/customerimport_folder'));
    }


    public function filterFiles($files)
    {
        $result = array();
        // filter .csv files
        foreach ($files as $f) {
            $extension = end(explode('.', $f));
            if (strtolower($extension) == 'csv') {
                $result[] = $f;
            }
            if (strtolower($extension) == 'xls') {
                $result[] = $f;
            }
        }
        return $result;
    }


    public function importFiles($files)
    {
        $result = false;
        foreach ($files as $file) {
            $result = $this->importFile($file);
        }
        return $result;
    }

    public function importFile($file)
    {

        $csv_data = $this->connector->read($file);
        $tmpfile = Mage::getBaseDir('var') . "/" . $file;
        file_put_contents($tmpfile, $csv_data);
        
        try {
            $row = 0;
            $arrayKeys = array();
            $customers = array();
            if (($handle = fopen($tmpfile, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 100000000, ",")) !== FALSE) {
                    $num = count($data);
                    if(!$row){
                        for ($c=0; $c < $num; $c++) {
                            $key = Mage::getStoreConfig('advanced/customerimport/customerimport_column' . ($c + 1));
                            $key = trim($key);
                            
                            //~ if($c == '7'){
                                //~ $key = 'billingaddress.street1';
                            //~ }
                            //~ if($c == '17'){
                                //~ $key = 'shippingaddress.street1';
                            //~ }
                            
                            $arrayKeys[$c] = $key;
                        }
                    }else{
                        for ($c=0; $c < $num; $c++) {
                            if($arrayKeys[$c]){
                                $customers[$row][$arrayKeys[$c]] = $data[$c];
                                
                                //~ if (strrpos($arrayKeys[$c], '.street') > 0 && !empty($customers[$row][$arrayKeys[$c]])) {
                                        //~ $customers[$row][$arrayKeys[$c]] .= ', '.$data[$c];
                                //~ } else {
                                        //~ $customers[$row][$arrayKeys[$c]] = $data[$c];
                                //~ }
                            }
                        }
                    }
                    $row++;
                }
                fclose($handle);
            }
        /*
        require_once(Mage::getBaseDir() . "/PHPExcel.php");
        $customers = array();

        try {
            $sheet_name = 'Customer_data';
            $objReader = PHPExcel_IOFactory::createReaderForFile($tmpfile);
            $objReader->setLoadSheetsOnly(array($sheet_name));
            $objReader->setReadDataOnly(true);

            $objPHPExcel = $objReader->load($tmpfile);


           

            $highestColumm = $objPHPExcel->setActiveSheetIndex(0)->getHighestColumn();
            $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();

            $m = 0;
            foreach ($objPHPExcel->setActiveSheetIndex(0)->getRowIterator() as $row) {
                $m = $m + 1;
                if ($m < 2) continue;
                $cellIterator = $row->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false);
                $customerData = array();
                $j = 0;

                foreach ($cellIterator as $cell) {
                    $j = $j + 1;
                    if (!is_null($cell)) {
                        
                        
                        
                        
                        
                        $value = $cell->getCalculatedValue();
                        $value = trim($value);
                        if (!empty($value)) {
                            $key = Mage::getStoreConfig('advanced/customerimport/customerimport_column' . $j);
                            $key = trim($key);
                        
                        
                            if($key == 'shippingaddress.postcode'){
                                //~ print_r(get_class_methods($cell));
                                //~ print_r(get_class_vars($cell));
                                //~ exit;
                            }
                            
                        
                        
                        
                            if (!empty($key)) {
                                if (strrpos($key, '.street') > 0 && !empty($customerData[$key])) {
                                    $customerData[$key] .= ', '.$value;
                                } else {
                                    $customerData[$key] = $value;
                                }
                            }
                        }
                    }
                }
                
                $customers[] = $customerData;
            }
            */
            
           
        } catch (Exception $e) {
            $this->connector->log('system', 'import file error ' . $e->getMessage(), $file);
            $this->connector->move($file, 'issues/' . $file);
            return false;
        }
        /*$lines = explode("\n", $csv_data);
        $head = str_getcsv(array_shift($lines));
        $data = array();
        foreach ($lines as $line) {
            $data[] = array_combine($head, str_getcsv($line));
        }*/

        unlink($tmpfile);

        try {
            $this->importToMagento($customers);
        } catch (Exception $e) {
            $this->connector->log('system', 'import file error ' . $e->getMessage(), $file);
            $this->connector->move($file, 'issues/' . $file);
            return false;
        }

        $this->connector->move($file, 'archive/' . $file);

        return true;
    }


    public function importToMagento($data)
    {   
        foreach ($data as $customerData) {
            $customer = Mage::getModel("customer/customer");
            if (!empty($customerData['email'])) {
                if (filter_var($customerData['email'], FILTER_VALIDATE_EMAIL) == false) {
                    continue;
                }
                $customer->setWebsiteId(2);
                
                
                //$customer->loadByEmail($customerData['email']);
                //OR
                $customer = Mage::getModel('customer/customer')
                    ->getCollection()
                    ->addAttributeToSelect('customercode')
                    ->addAttributeToFilter('customercode',$customerData['customercode'])
                    ->getFirstItem();
            
            
            }

            if (!$customer->getId()) {
                $customer = Mage::getModel('customer/customer');
                $customer->setEmail($customerData['email']);
                if (isset($customerData['fullname'])) {
                    $names = explode(' ', $customerData['fullname']);

                    if (isset($names[0])) {
                        $customerData['firstname'] = $names[0];
                    }
                    if (isset($names[1])) {
                        $customerData['lastname'] = $names[1];
                    }
                }
                $customer->setFirstname($customerData['firstname']);
                $customer->setLastname($customerData['lastname']);
                $customer->setPassword('iscalamagento');
                $customer->setStore(Mage::app()->getStore());
            } else {
                if (isset($customerData['fullname'])) {
                    $names = explode(' ', $customerData['fullname']);

                    if (isset($names[0])) {
                        $customerData['firstname'] = $names[0];
                    }
                    if (isset($names[1])) {
                        $customerData['lastname'] = $names[1];
                    }
                }
                $customer->setFirstname($customerData['firstname']);
                $customer->setLastname($customerData['lastname']);
            }
            $customer->setWebsiteId(2);

            $shipping_address = array();
            $billing_address = array();
            foreach ($customerData as $key => $value) {
                if (strrpos($key, 'illingaddress.')) {
                    $newkey = explode('.', $key);
                    $billing_address[$newkey[1]] = $value;
                } elseif (strrpos($key, 'hippingaddress.')) {
                    $newkey = explode('.', $key);
                    $shipping_address[$newkey[1]] = $value;
                } else {
                    $customer->setData($key, $value);
                }
            }
            $email = $customer->getEmail();


            if (!$email) {
                continue;
            }

            $orig_data = $customer->getData();

            $customer->setConfirmation(null);
            $customer->setStatus(1);
            $customer->save();
            
            $address_shipping = array(
                'firstname' => $shipping_address['firstname'],
                'lastname' => $shipping_address['lastname'],
                'street' => array(
                    '0' => ($shipping_address['street']) ? $shipping_address['street'] : '',
                    '1' => ($shipping_address['street1']) ? $shipping_address['street1'] : '',
                ),
                'company' => ($shipping_address['company']) ? $shipping_address['company'] : '',
                'city' => ($shipping_address['city']) ? $shipping_address['city'] : '',
                'region_id' => '',
                'region' => ($shipping_address['region']) ? $shipping_address['region'] : '',
                'postcode' => ($shipping_address['postcode']) ? $shipping_address['postcode'] : '',
                'country_id' => 'NZ',
                'telephone' => $shipping_address['telephone'],
            );
            $shipping = Mage::getModel('customer/address');
            $shipping->setData($address_shipping)
                ->setCustomerId($customer->getId())
                ->setIsDefaultBilling('0')
                ->setIsDefaultShipping('1')
                ->setSaveInAddressBook('1');
            if($customer->getPrimaryShippingAddress()){
                $shipping->setId($customer->getPrimaryShippingAddress()->getId());
            }
            
            $shipping->save();

            $address_billing = array(
                'firstname' => $customer->getFirstname(),
                'lastname' => $customer->getLastname(),
                'street' => array(
                    '0' => ($billing_address['street']) ? $billing_address['street'] : '',
                    '1' => ($billing_address['street1']) ? $billing_address['street1'] : '',
                ),
                'company' => ($billing_address['company']) ? $billing_address['company'] : '',
                'city' => ($billing_address['city']) ? $billing_address['city'] : '',
                'region_id' => '',
                'region' => ($billing_address['region']) ? $billing_address['region'] : '',
                'postcode' => $billing_address['postcode'],
                'country_id' => 'NZ',
                'telephone' => ($billing_address['telephone']) ? $billing_address['telephone'] : '',
            );
            $billing = Mage::getModel('customer/address');
            $billing->setData($address_billing)
                ->setCustomerId($customer->getId())
                ->setIsDefaultBilling('1')
                ->setIsDefaultShipping('0')
                ->setSaveInAddressBook('1');
            if($customer->getPrimaryBillingAddress()){
                $billing->setId($customer->getPrimaryBillingAddress()->getId());
            }
             
            $billing->save();
        }
    }


    public function cron()
    {

        if (!Mage::getStoreConfig('advanced/customerimport/customerimport_active')) return;
        Mage::log('import customers started', null, 'multichem-integration.log');
        $this->init();
        $contents = $this->connector->ls("");
        $files = $this->filterFiles($contents['file']);
        $result = $this->importFiles($files);
        return $result;

    }
    public function cronHourly(){
		if(Mage::getStoreConfig('advanced/customerimport/customerimport_hourly') == 1)
            $this->cron();
	}


}

