<?php
class Magebin_Productimport_Model_Import {
    
    const XML_PATH_NOTIFY_ENABLE   = 'advanced/productimport_settings/enable_notify';
    const XML_PATH_NOTIFY_EMAILS   = 'advanced/productimport_settings/email_notify';
    const XML_PATH_NOTIFY_TEMPLATE = 'advanced/productimport_settings/template_notify';
    
    const MSG_ERR    = 1;
    const MSG_NOTIFY = 2;
	
    public $connector;
    
    protected $_errors = array();
    protected $_warning = array();
    
    /**
     * Notify is enable
     * @return bool
     */
    protected function isNotifyEnable() {
        return Mage::getStoreConfigFlag(self::XML_PATH_NOTIFY_ENABLE);
    }
    
    /**
     * Notify email
     * @return array
     */
    protected function getNotifyEmails() {
        $emails = explode(",", Mage::getStoreConfig(self::XML_PATH_NOTIFY_EMAILS));
        foreach ($emails as &$email){
            $email = strtolower(trim($email));
        }
        return $emails;
    }
    
    /**
     * Notify email template
     * @return string
     */
    protected function getNotifyTemplate() {
        $template = Mage::getStoreConfig(self::XML_PATH_NOTIFY_TEMPLATE);
        if (is_string($template)){
            $template = 'productimport_notify_email';
        }
        return $template;
    }
    
    /**
     * Set Message
     * @param string $message
     * @param int $type
     * @return Magebin_Productimport_Model_Import
     */
    protected function setMessage($message, $type) {
        if ($message){
            switch ($type){
                case self::MSG_ERR:
                    array_push($this->_errors, trim($message));
                    break;
                case self::MSG_NOTIFY:
                    array_push($this->_warning, trim($message));
                    break;
            }
        }
        return $this;
    }
    
    /**
     * Send notify email
     *
     * @return Magebin_Productimport_Model_Import
     */
    protected function sendNotifyEmail()
    {
        var_dump($this->htmlError());
        var_dump($this->htmlWarning());
        
        return $this;
        
        
        if (!$this->isNotifyEnable() 
                || !count($this->getNotifyEmails())){
            return $this;
        }
        
        $storeId = Mage_Core_Model_App::ADMIN_STORE_ID;

        // Get the destination email addresses to send copies to
        $copyTo = $this->getNotifyEmails();

        // Start store emulation process
        $appEmulation = Mage::getSingleton('core/app_emulation');
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);

        // Stop store emulation process
        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);

        // Retrieve corresponding email template id and customer name
        $templateId = $this->getNotifyTemplate();

        $mailer = Mage::getModel('core/email_template_mailer');
        $emailInfo = Mage::getModel('core/email_info');
        

        // Email copies are sent as separated emails if their copy method is 'copy'
        if ($copyTo) {
            foreach ($copyTo as $email) {
                $emailInfo = Mage::getModel('core/email_info');
                $emailInfo->addTo($email);
                $mailer->addEmailInfo($emailInfo);
            }
        }

        // Set all required params and send emails
        $mailer->setSender(Mage::getStoreConfig(Mage_Sales_Model_Order::XML_PATH_EMAIL_IDENTITY, $storeId));
        $mailer->setStoreId($storeId);
        $mailer->setTemplateId($templateId);
        $mailer->setTemplateParams(array(
                'countErr'   => $this->countErr(),
                'countWarning'   => $this->countWarning(),
                'errors'   => $this->htmlError(),
                'warnings' => $this->htmlWarning()
            )
        );
        
        $mailer->send();


        return $this;
    }
    
    /**
     * HTML Errors
     * @return string
     */
    public function htmlError() {
        $html = '<ul>';
        foreach ($this->getErrors() as $msg){
            $html .= sprintf('<li>%s</li>', $msg);
        }
        $html .= '<ul>';
        return $html;
    }
    
    /**
     * HTML Warning
     * @return string
     */
    public function htmlWarning() {
        $html = '<ul>';
        foreach ($this->getWarning() as $msg){
            $html .= sprintf('<li>%s</li>', $msg);
        }
        $html .= '<ul>';
        return $html;
    }
    
    /**
     * Count Warning
     * @return int
     */
    public function countWarning() {
        return count($this->getWarning());
    }
    
    /**
     * Count errors
     * @return int
     */
    public function countErr() {
        return count($this->getErrors());
    }
    
    /**
     * Msg. Errors
     * @return array
     */
    public function getErrors() {
        return $this->_errors;
    }
    
    /**
     * Msg. Warning
     * @return array
     */
    public function getWarning() {
        return $this->_warning;
    }

    public function init(){
        
        if(!Mage::getStoreConfig('advanced/productimport/productimport_active')){ 
            return;
        }
        
        if(!function_exists('ssh2_connect')){
            $this->setMessage(Mage::helper('productimport')->__("php ssh2 package is not installed"), self::MSG_ERR);
            return;
        }
        
        $this->connector = Mage::getStoreConfig('advanced/productimport/productimport_connect');
        $this->connector = Mage::getModel('productimport/adapter_'.$this->connector);
        $this->connector->initLog(Mage::getModel('productimport/log'));
        $this->connector->login(Mage::getStoreConfig('advanced/productimport/productimport_remote'),Mage::getStoreConfig('advanced/productimport/productimport_port'),Mage::getStoreConfig('advanced/productimport/productimport_username'),Mage::getStoreConfig('advanced/productimport/productimport_password'));
        $this->connector->cd(Mage::getStoreConfig('advanced/productimport/productimport_folder'));
    }
	
    public function filterFiles($files){
        if (is_array($files)){
            $result = array();
            // filter .csv files
            foreach($files as $f){
                $extension = end(explode('.', $f));
                if(strtolower($extension)=='csv'){
                    $result[] = $f;
                }
                if(strtolower($extension)=='xls'){
                    $result[] = $f;
                }
            }
        }
        return $result;
    }


    public function importFiles($files){
        foreach($files as $file){
            $this->importFile($file);
        }
    }
	
    public function importFile($file){

        $csv_data = $this->connector->read($file);
        $dirVar   = Mage::getBaseDir('var');
        $tmpfile  = $dirVar."/".$file;

        $libExcel = Mage::getBaseDir()."/PHPExcel.php";

        if (!is_writable($dirVar)){
            $this->setMessage(Mage::helper('productimport')->__("Directory %s is not writeable", $dirVar), self::MSG_ERR);
            return false;
        }

        //Write to tmp file
        file_put_contents($tmpfile, $csv_data);

        if (is_readable($libExcel)){
            require_once($libExcel);
        } else {
            $this->setMessage(Mage::helper('productimport')->__("Library %s is not found", $libExcel), self::MSG_ERR);
            return false;
        }

        $products = array();

            try{

                $sheet_name = 'Product_Export_02';
                $objReader = PHPExcel_IOFactory::createReaderForFile($tmpfile);
                $objReader->setLoadSheetsOnly(array($sheet_name));
                $objReader->setReadDataOnly(true);

                $objPHPExcel = $objReader->load($tmpfile);
                $highestColumm = $objPHPExcel->setActiveSheetIndex(0)->getHighestColumn();
                $highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();

                $m = 0;

                foreach ($objPHPExcel->setActiveSheetIndex(0)->getRowIterator() as $row) {
                    
                    $m=$m+1;
                    
                    if($m<2){ 
                        continue;
                    }
                    
                    $cellIterator = $row->getCellIterator();
                    $cellIterator->setIterateOnlyExistingCells(false);
                    
                    $productData = array();$j=0;

                    foreach ($cellIterator as $cell) {
                        $j=$j+1;
                        if (!is_null($cell) ) {
                            $value = $cell->getCalculatedValue();
                            $value = trim($value);
                            if( !empty($value) ){
                                $key = Mage::getStoreConfig('advanced/productimport/productimport_column'.$j);
                                $key = trim($key);
                                if(!empty($key)){
                                    $productData[$key] = $value;
                                } else {
                                    $this->setMessage(Mage::helper('productimport')->__("Column exists %s (settings) but data not found", $key), self::MSG_NOTIFY);
                                }
                            }
                        }
                    }
                    
                    $products[] = $productData;
            }
            
        } catch(Exception $e) {
            
            $this->setMessage($e->getMessage(), self::MSG_ERR);
            
            $this->connector->log('system','import file error[a] ' . $e->getMessage(),$file);
            $this->connector->move($file,'issues/'.$file);
            
            return false;
        }

        /*$lines = explode("\n", $csv_data);
        $head = str_getcsv(array_shift($lines));
        $data = array();
        foreach ($lines as $line) {
                $data[] = array_combine($head, str_getcsv($line));
        }*/

        @unlink($tmpfile);

        try{
            
            //$this->connector->move($file,'archive/'.$file);
            $this->importToMagento($products);

        } catch(Exception $e){
            
            $this->setMessage($e->getMessage(), self::MSG_ERR);
            
            $this->connector->move($file,'issues/'.$file);
            $this->connector->log('system','import file error[b] ' . $e->getMessage(),$file);
            
            return false;
        }
            
        return true;
    }
	
	
    public function importToMagento($data){
        
        foreach($data as $productData){
            
            if(!isset($productData['sku'])) {
                continue;
            }
            
        $product_id = Mage::getModel('catalog/product')->getIdBySku($productData['sku'] );
        //if(!is_null($product_id) ){
            $product = Mage::getModel('catalog/product');	
            //$product = Mage::getModel('catalog/product')->load($product_id);	
            
            $qty = '0';
            
            foreach($productData as $key=>$value){
                if($key == 'qty'){
                    //$newkey = explode('.',$key);
                    $qty = $value;
                    $stock_status = ($qty > 0)? 1 : 0 ;
                    //~ $product->setStockData(array( 
                        //~ $newkey[1] => $value,
                    //~ )); 
                }else{
                    $product->setData($key,$value);
                }
            }

            if(!$product_id){
                $product->setAttributeSetId('4')
                    ->setTypeId('simple')
                    ->setCategoryIds(array(2))
                    ->setWebsiteIDs(array(1,2))
                    ->setDescription($productData['name'])
                    ->setShortDescription($productData['name'])
                    ->setWeight(0)
                    ->setVisibility(1)
                    ->setTaxClassId(0)
                    ->setStatus(1);
            }

            try{
                $product->setId($product_id);	
                $product->getResource()->save($product);

                $product = $product->load($product->getId());
                $product->setStockData(array(
                    'use_config_manage_stock' => 0, //'Use config settings' checkbox
                    'manage_stock' => 1, //manage stock
                    //~ 'min_sale_qty' => 1, //Minimum Qty Allowed in Shopping Cart
                    //~ 'max_sale_qty' => 9999, //Maximum Qty Allowed in Shopping Cart
                    //'is_in_stock'  => $stock_status,
                    'is_in_stock'  => 1,
                    'qty'          => (string)$qty
                    )
                );
                
                $product->save();
                
                //~ $stock = $product->getStockItem();
                //~ if (!$stock->getIsInStock()) {					
                                            //~ $qty = $product->getStockItem()->getQty();
                                            //~ if($qty>0){
                                                    //~ $stock->setData('is_in_stock', 1);
                        //~ $stock->save();
                                            //~ }
                                    //~ }
                            } catch(Exception $e){
                                $this->setMessage($e->getMessage(), self::MSG_ERR);
                
                            }

        //}
            }

            /*foreach($data as $productData){
                    $product = null;
                    $product_id = null;
                    if(!empty($productData['sku'])){
                            $product_id = Mage::getModel('catalog/product')->getIdBySku($productData['sku'] );

                            if(isset($product_id) && $product_id!=false && $product_id!=null ){
                                    //continue;
                                    try{
                                            $product = Mage::getModel('catalog/product')->load($product_id);		

                                            foreach($productData as $key=>$value){
                                                    if(strrpos($key,'tock.')){
                                                            $newkey = explode('.',$key);
                                                            $product->setStockData(array( 
                                                                    $newkey[1] => $value 
                                                            )); 
                                                    }else{
                                                            $product->setData($key,$value);
                                                    }
                                            }

                                            $product->save();

                                    }catch(Exception $e){


                                    }
                            }
                    }

                    if(empty($product) || $product==null || !isset($product_id)){
                            continue;
                            $product = Mage::getModel('catalog/product');
                            $product->setSku(time()); 
                            $product->setAttributeSetId('4');
                            $product->setTypeId('simple'); 
                            $product->setName('iscala product'); 
                            $product->setCategoryIds(array(0)); # some cat id's, 
                            $product->setWebsiteIDs(array(1)); # Website id, 1 is default 
                            $product->setDescription('description'); 
                            $product->setPrice(0);
                            $product->setWeight(0); 
                            $product->setVisibility(Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH); 
                            $product->setTaxClassId(0); 	
                    }


                    $product->setStatus(0); 
                    foreach($productData as $key=>$value){
                            if(strrpos($key,'tock.')){
                                    $newkey = explode('.',$key);
                                    $product->setStockData(array( 
                                            $newkey[1] => $value 
                                    )); 
                            }else{
                                    $product->setData($key,$value);
                            }
                    }

            try{	

                    $product->save();
            }catch(Exception $e){


                    $this->connector->log('system','import product error[d] '.var_export($product,true).  $e->getMessage(),$file);

            }


            }*/
    }


    public function cron(){

        if(!Mage::getStoreConfig('advanced/productimport/productimport_active')){
            return;
        }

        Mage::log('import products started', null, 'multichem-integration.log');

        $this->init();
        
        if ($this->connector){
            $contents = $this->connector->ls("");
        } else {
            $this->setMessage(Mage::helper('productimport')->__("Connection does not initialized"), self::MSG_ERR);
        }
        
        if (isset($contents['file'])){
            $files = $this->filterFiles($contents['file']);
            $this->importFiles($files);
        } else {
            $this->setMessage(Mage::helper('productimport')->__("List of files is empty"), self::MSG_NOTIFY);
        }

        if ($this->countErr() || $this->countWarning()){
            $this->sendNotifyEmail();
        }

        Mage::log('import products ended', null, 'multichem-integration.log');
        
        return true;
    }
	
    public function cronHourly(){
        if(Mage::getStoreConfig('advanced/productimport/productimport_hourly') == 1){
            $this->cron();
        }
    }
}

