<?php
class Magebin_Productimport_Model_Attributes {
    
    /**
     * Stock Attributes
     * @param bool $asOption
     * @return array
     */
    public function toStockOptionArray($asOption=true) {
        return array(
            array('label' => 'Min Sale Qty','value' => 'min_sale_qty'),
            array('label' => 'QTY','value' => 'qty'),
            array('label' => 'msrp','value' => 'msrp')
        );
    }
    
    /**
     * Product Attributes
     * @param bool $asOption
     * @return array
     */
    public function toProductOptionArray($asOption=true){
        $options = array();
	
        $reserved = Mage::getModel('catalog/product')->getReservedAttributes();
        $attributes = Mage::getModel('catalog/product')->getAttributes();

        if ($asOption){
            $options[] = array(
                'label' => Mage::helper('adminhtml')->__(''),'value' => ''
            );
        }
	
        foreach ($reserved as $attribute){ 
            if ($asOption){
                $options[] = array('label' => $attribute,'value' => $attribute);
            } else {
                array_push($options, $attribute);
            }
        }
	
        foreach ($attributes as $attribute){ 
            if ($asOption){
                $options[] = array(
                'label' => $attribute->getName(),'value' => $attribute->getName()
                    );
            }
        }
        
        return $options;
    }
    
    /**
     * All Attributes
     * @return array
     */
    public function toOptionArray(){
        return array_merge($this->toProductOptionArray(), $this->toStockOptionArray());
    }
}
