<?php

class Magebin_Productimport_Model_Adapter_Sftp implements  Magebin_Productimport_Model_Adapter_Interface{
	
	private $_ip, $_port, $_username, $_password, $_folder, $_sftp, $_connection, $_log;

	
    public function login($remoteip, $port, $username, $password){
		if(!function_exists('ssh2_connect')) throw new Exception('php ssh2 package is not installed, please contact dan@magebin.com');
		$this->_ip = $remoteip;
		$this->_port = $port;
		$this->_username = $username;
		$this->_password = $password;
		$this->_folder = '';
		try{
			$this->_connection = ssh2_connect($this->_ip, $this->_port);
			ssh2_auth_password($this->_connection, $this->_username, $this->_password);
			$this->_sftp = ssh2_sftp($this->_connection);
		}catch(Exception $e){
			$error = 'can not create connection to sftp server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
	
	}
	public function cd($folder, $subfolder = false){
		if(!$subfolder)
		$this->_folder = $folder;
		if($subfolder)
		$this->_folder .= $folder;
	}
	
	public function quit(){
		unset($this->_sftp);
	}
	
	public function exec($cmd){
		 if (!($stream = ssh2_exec($this->_connection, $cmd))) { 
			$error = 'can not execute command '.$cmd;
			$this->log('system', $error);
            throw new Exception($error); 
        } 
        stream_set_blocking($stream, true); 
        $data = ""; 
        while ($buf = fread($stream, 4096)) { 
            $data .= $buf; 
        } 
        fclose($stream); 
        return $data; 
	}
	
	public function initLog($log){
		$this->_log = $log;
	
	}
	
	public function log($messageType, $message,$file=''){
		$this->_log->log($messageType,$message,$file);
	}
	
	public function put($localfile, $remotefile){
		$result = false;
		try{
			$result = ssh2_scp_send($this->_connection, $localfile, $$this->_folder. $remotefile, 0777);
		}catch(Exception $e){
			$error = 'can not upload file '.$localfile.' to remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	}
	
	
	public function get($remotefile, $localfile){
		$result = false;
		try{
			$result = ssh2_scp_recv($this->_connection, $this->_folder.$remotefile, $localfile);
		}catch(Exception $e){
			$error = 'can not download file '.$remotefile.' to local server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	}
	
	
	public function read($remotefile){
		$result = null;
		$src = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $remotefile;
		try{
			$result = file_get_contents($src);
		}catch(Exception $e){
			$error = 'can not read file '.$remotefile.', error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	
	
	}
	
	public function write($filename,$content=''){
		$src = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $filename;
		try{
			//file_put_contents($src, $content, FILE_APPEND);
			$handle = fopen($src,'w');
			fwrite ($handle ,  $content );
		}catch(Exception $e){
			$error = 'can not write file '.$filename.', error: '.$e->getMessage();
			$this->log('system',$error);
		
		}
		return true;
	
	
	}
	
	
	/*public function readxml(){
		include Mage::getBaseDir('base')."excel_reader2.php";
		

		$src = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $remotefile;
	
		try{
			$data = new Spreadsheet_Excel_Reader($src,false);
		}catch(Exception $e){
			$error = 'can not read file '.$remotefile.', error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $data;
		
	}*/
	
	
	public function delete($remotefile){
		$result = false;
		try{
			$result = ssh2_sftp_unlink($this->_connection, $this->_folder.$remotefile);
		}catch(Exception $e){
			$error = 'can not delete file '.$remotefile.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	}
	
	
	public function move($src, $dest){
	
		$src = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $src;
		$dest = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $dest;
		$fsrc = fopen($src,'r'); 
        $fdest = fopen($dest,'w+'); 
		try{
			$len = stream_copy_to_stream($fsrc,$fdest);
		}catch(Exception $e){
			$error = 'can not move file '.$src.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
        fclose($fsrc); 
        fclose($fdest); 
		unlink($src);
        return $len; 
	
	}
	public function exist($remotefile){
		return file_exists('ssh2.sftp://' . $this->_sftp .$this->_folder. $remotefile);
	}
	
	public function ls($remotefolder=''){
		$contents = scandir('ssh2.sftp://' . $this->_sftp .$this->_folder.$remotefolder);
		$result = array();
		foreach($contents as $file){
			if(is_file('ssh2.sftp://' . $this->_sftp .$this->_folder.$file))
			$result['file'][]=$file;
			if(is_dir('ssh2.sftp://' . $this->_sftp .$this->_folder.$file) && $file!='.' && $file!='..')
			$result['dir'][]=$file;
		}
		return $result;
	}
	
	
	public function mkfile($filename){
		$result = false;
		try{
			$filename = 'ssh2.sftp://' . $this->_sftp .$this->_folder. $filename;
			$result = fopen($filename, 'w');
		}catch(Exception $e){
			$error = 'can not create file '.$filename.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return true;;
	}
	
	
	
	public function mkdir($remotefolder){
		$result = false;
		try{
			$result = ssh2_sftp_mkdir($this->_connection, $this->_folder.$remotefolder);
		}catch(Exception $e){
			$error = 'can not create folder '.$remotefolder.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	
	}
	public function rename($filename, $newname){
	
		$result = false;
		try{
			$result = ssh2_sftp_rename ($this->_connection, $this->_folder.$filename, $this->_folder.$newname);
		}catch(Exception $e){
			$error = 'can not rename file '.$filename.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	
	
	}
	public function chmod($file, $mode){
	
		$result = false;
		try{
			$result = ssh2_sftp_chmod ($this->_connection, $this->_folder.$file, $mode);
		}catch(Exception $e){
			$error = 'can not chmod file '.$file.' on remote server, error: '.$e->getMessage();
			$this->log('system',$error);
		}
		return $result;
	
	
	}

}


